﻿<%@ Language = "VBScript" %>
<%
Option Explicit
Response.Buffer = True
Response.CharSet="UTF-8"
Server.ScriptTimeOut = 90

'调试时注释掉此行
'On Error Resume Next

' 开始运行时刻，数据库操作次数
Dim StartTime, QueryNum
StartTime = Timer()
QueryNum = 0
%>
<!-- #include file = "../../Include/Config.asp" -->
<%
'打开数据库连接
Dim Conn, Rs
Set Conn = Server.CreateObject("Adodb.Connection")
Conn.Open = "Provider=Microsoft.jet.OLEDB.4.0;Data Source=" & Server.MapPath( DataPath )
If Err Then
	Err.Clear
	ShowMessage "数据库连接出错", ""

	Conn.Close
	Set Conn = Nothing

	Session.Abandon
	Response.End
End If

'初始化缓存
If IsEmpty( Application("BufferUpdateTime") ) Then
	CacheInitialize()
End If
'更新缓存
If DateDiff( "n", Application("BufferUpdateTime"), Now() ) > 5 Then
	CacheRndArticle()
	Application.Lock
	Application("BufferUpdateTime") = Now()
	Application.UnLock
End If
'在线人数统计
CacheOnlineNum()
'加载配置信息
Dim BlogName,BlogDescription,BlogKeyWords,BlogBeiAn,BlogDomain,SideBuildDate,SideVisitNum,SideTodayVisitNum,BlogMaxPerPage,BlogMaxOnline,BlogFilterWords
Dim BlogNameFilter,BlogEnable,BlogCloseReason,BlogRegEnable,BlogComment,BlogComTimer,BlogComMaxLength,BlogArtMaxLength,BlogArtType,BlogShowType,BlogVerify
Dim BlogVersion,BlogStyle,BlogDesigner,SideArticleClass,SideNewArticle,SideRndArticle,SideNewComment,SideHotArticle,SideNewGuestbook
Dim SideLink,MenuItem,WidgetItem,SideArticleNum,SideCommentNum,SideGuestbookNum,SideUserNum,OnlineNum
CacheLoadSet()

'定义错误陷阱
Sub CheckError()
	If Err Then
		Err.Clear
		ShowMessage "博客程序出现未知错误，此次请求被取消", ""
		Response.End
	End If
End Sub

'--------------------------------------------
' 名称：CheckLogin()
' 作用：判断是否登录
' 其他：包括 1 - 10 用户组
'--------------------------------------------
Function CheckLogin()
	If Session("UserGroup") > 0 Then
		CheckLogin = True
	Else
		CheckLogin = False
	End If
End Function

'--------------------------------------------
' 名称：CheckAdmin()
' 作用：判断是否有前台管理权限
' 其他：包括 8, 9, 10 用户组
'--------------------------------------------
Function CheckAdmin()
	If Session("UserGroup") > 7 Then
		CheckAdmin = True
	Else
		CheckAdmin = False
	End If
End Function

'--------------------------------------------
' 名称：CheckSuperAdmin()
' 作用：判断是否有后台管理权限
' 其他：包括 10 用户组
'--------------------------------------------
Function CheckSuperAdmin()
	If Session("UserGroup") > 9 Then
		CheckSuperAdmin = True
	Else
		CheckSuperAdmin = False
	End If
End Function

Function GetTotalSize(GetLocal, GetType)
    On Error Resume Next
    Dim FSO
    Set FSO = Server.CreateObject("Scripting.FileSystemObject")
    If Err<>0 Then
        Err.Clear
        GetTotalSize = "Fail"
    Else
        Dim SiteFolder
        If GetType = "Folder" Then
            Set SiteFolder = FSO.GetFolder(GetLocal)
        Else
            Set SiteFolder = FSO.GetFile(GetLocal)
        End If
        GetTotalSize = SiteFolder.Size
        If GetTotalSize>1024 * 1024 Then
            GetTotalSize = GetTotalSize / 1024 / 1024
            If InStr(GetTotalSize, ".") Then GetTotalSize = Left(GetTotalSize, InStr(GetTotalSize, ".") + 2)
            GetTotalSize = GetTotalSize&" MB"
        Else
            GetTotalSize = Fix(GetTotalSize / 1024)&" KB"
        End If

        Set SiteFolder = Nothing
    End If
    Set FSO = Nothing
End Function

%>

<!-- #include file = "../../Function/Cache.asp" -->
<!-- #include file = "../../Function/Data.asp" -->
<!-- #include file = "../../Function/Function.asp" -->